import { View, TouchableWithoutFeedback, TouchableOpacity, StyleSheet } from "react-native";
import Share from "react-native-share";
import React from "react";
import { productDetailsStyle } from "../ProductDetailsStyle";
import { useRef, useEffect } from "react";
import LottieView from "lottie-react-native";
import ShareIcon from "../../../../../assets/svgs/product details/share.svg";
import dpr from "../../../../Utilities/CustomStyleAttribute/dpr";
import useAuth from "../../../../../hooks/useAuth";
import { useNavigation } from "@react-navigation/native";
import { mutationResponse } from "../../../../../redux/slices/util/processResponse.js";
import { useSelector } from "react-redux";
import { useDispatch } from "react-redux";
import {
    isWishlist,
    getMyWishlist,
    storeTempWishlist,
} from "../../../../../redux/slices/user/myWishlist/getMyWishlist";
import { mutation } from "../../../../../redux/slices/util/apiRequest";
import usePreferences from "../../../../../hooks/usePreferences";

import { BASE_API_URL_STG, SCHEME } from "@env";
import { PRODUCT_DETAILS } from "../../../../../components/Navigation/RouteNames";
import CustomSVG from "../../../../../src/components/CustomSVG/CustomSVG";

const WISHLIST_URL = `${BASE_API_URL_STG}/user/wishlists`;

const iconSize = dpr(35);

const ShareNwishlist = ({
    productId,
    routeName,
    slug,
    name,
    is_wishlisted,
    shareLink,
    wishlist_id,
}) => {
    const dispatch = useDispatch();
    const { wishlist } = useSelector(
        (state) => state.getMyWishlistSlice
    );
    const { product_general: { wishlist: showWishlist } = {} } =
        usePreferences();
    const wishlistRef = useRef(null);
    const isFirstRun = useRef(true);
    const { access_token, user } = useAuth();
    const navigation = useNavigation();
    useEffect(() => {
        if (Number(showWishlist) && isFirstRun.current) {
            if (wishlist) wishlistRef?.current?.play(66, 66);
            else wishlistRef?.current?.play(23, 23);
            isFirstRun.current = false;
        } else if (wishlist) wishlistRef?.current?.play(27, 50);
        else wishlistRef?.current?.play(0, 23);
    }, [wishlist]);

    useEffect(() => {
        isFirstRun.current = true;
        if (is_wishlisted) {
            dispatch(isWishlist(true));
        } else {
            dispatch(isWishlist(false));
        }
    }, [is_wishlisted]);

    const handleWishlist = () => {
        isFirstRun.current = false;
        if (!access_token && !user) {
            dispatch(storeTempWishlist(productId));
            navigation.navigate("login", {
                redirectRouteName: routeName,
                data: {
                    slug: slug,
                },
            });
        }
        if (access_token && user && !wishlist) {
            dispatch(isWishlist(!wishlist));
            const URL = `${BASE_API_URL_STG}/user/wishlist`;
            let formData = new FormData();
            formData.append("product_id", productId);
            dispatch(getMyWishlist({ access_token, URL: WISHLIST_URL }));
            mutationResponse(
                URL,
                "POST",
                formData,
                access_token
            );
        }
        if (access_token && user && wishlist && wishlist_id) {
            const WISHLIST_DELETE_URL = `${BASE_API_URL_STG}/user/wishlist/delete/${wishlist_id}`;
            mutation(WISHLIST_DELETE_URL, "DELETE", {}, access_token);
            dispatch(isWishlist(!wishlist));
        }
    };
    
    const handleShare = async () => {
        const productLink = `${SCHEME}://${PRODUCT_DETAILS}/${slug}`;
        const content = {
            url: shareLink || productLink,
            title: name,
        };
        Share.open(content)
            .then((res) => {})
            .catch((err) => {});
    };

    return (
        <View style={productDetailsStyle.header}>
            {showWishlist == 1 && (
                <TouchableWithoutFeedback onPress={() => handleWishlist()}>
                    <View style={productDetailsStyle.wishlistContainer}>
                        <View>
                            <LottieView
                                ref={wishlistRef}
                                source={require("../../../../../assets/lottie/wishlist.json")}
                                autoPlay={false}
                                loop={false}
                                style={styles.LottieView}
                            />
                        </View>
                    </View>
                </TouchableWithoutFeedback>
            )}
            <TouchableOpacity onPress={async () => await handleShare()}>
                <CustomSVG svgIcon={ShareIcon} height={iconSize} width={iconSize} />
            </TouchableOpacity>
        </View>
    );
};

export default ShareNwishlist;

const styles = StyleSheet.create({
    LottieView: {
        height: dpr(50),
        width: dpr(30),
    },
});
